import random
import string

from app.models.transactions import Credit, Debit


def _random_suffix(length: int = 8) -> str:
    return "".join(random.choices(string.digits, k=length))


def generate_debit_transaction_id(prefix: str = "TD", *, length: int = 8) -> str:
    for _ in range(10):
        candidate = f"{prefix}{_random_suffix(length)}"
        if not Debit.query.filter_by(transaction_id=candidate).first():
            return candidate
    return f"{prefix}{_random_suffix(length)}"


def generate_credit_transaction_id(prefix: str = "TC", *, length: int = 8) -> str:
    for _ in range(10):
        candidate = f"{prefix}{_random_suffix(length)}"
        if not Credit.query.filter_by(transaction_id=candidate).first():
            return candidate
    return f"{prefix}{_random_suffix(length)}"

